# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import re
import json
import threading
import traceback
import base64
import webbrowser
import sys
from ctypes import *

from utilsEx import *
from youtube_upload import main
from authupload import CreateAuInstance

class supportCallbackObjct(object):
    def __init__(self):
        self.callback = None
        self.userObj = None
        self.pyCallback = None
    #设置回调
    def setCallback(self, c_callback):
        if not c_callback:
            return
        
        debug('setCallback begin')
        # 3.0，api改了
        if sys.version_info >= (3, 0):
            PyCapsule_GetPointer = PYFUNCTYPE(c_void_p, py_object)(('PyCapsule_GetPointer', pythonapi))
            PyCapsule_GetName = PYFUNCTYPE(c_void_p, py_object)(('PyCapsule_GetName', pythonapi))
            c_callbackaddr = PyCapsule_GetPointer(c_callback, PyCapsule_GetName(c_callback))
        else:
            PyCObject_AsVoidPtr = PYFUNCTYPE(c_void_p, py_object)(('PyCObject_AsVoidPtr', pythonapi))
            c_callbackaddr = PyCObject_AsVoidPtr(c_callback)

        CALLBACKFUNC_T = CFUNCTYPE(c_long, c_char_p, c_long)
        self.callback = CALLBACKFUNC_T(c_callbackaddr)
        debug('setCallback end')

    def setPyCallback(self, callback):
        self.pyCallback = callback

    def setUserObj(self, userObj):
        debug('setUserObj Begin %d' % userObj)
        self.userObj = userObj
        debug('setUserObj End %d' % userObj)
    #回调给外部
    def sendMessage(self, msg):
        try:
            if self.callback:
                debug('.............................self.callback: %s' % msg)
                self.callback(c_char_p(msg.encode('utf-8')), c_long(int(self.userObj)))
            if self.pyCallback:
                self.pyCallback(msg)
        except:
            debug(traceback.format_exc())

class Interface(supportCallbackObjct):
    pass

class VideoUploader(Interface):
    def init(self, brand, website):
        main.notifyEvent = self.sendMessage
        self._brand = brand.lower()
        self._website = website.lower()
        self._cancel = False
        self._running = None
        self._uploader = CreateAuInstance(website)
        debug('uploader instance create success.' if self._uploader != None else 'uploader instance create failed.')
        self._uploader.SetBrand(brand.lower())
        self._retry = False

    def SetBrand(self, brand):
        self._uploader.SetBrand(brand)

    def SetAppInfo(self, appId, appSecret, redirectURL):
        self._uploader.SetAppKey(appId)
        self._uploader.SetAppSecret(appSecret)
        self._uploader.SetRedirectURL(redirectURL)

    def GetAppKey(self):
        return self._uploader.GetAppKey()

    def GetAppSecret(self):
        return self._uploader.GetAppSecret()

    def GetAccessToken(self):
        token = self._uploader.GetAccessToken()
        self.sendMessage('TOKEN=' + token)
        return token

    def GetVideoCategory(self):
        category = self._uploader.GetVideoCategories()
        self.sendMessage('CATEGORY=' + category)
        return category

    def GetLoginURL(self):
        try:
            url = self._uploader.GetLoginURL()
            if type(url) == bytes:
                url = url.decode()
            self.sendMessage('LOGINURL='+ url)
            return url
        except Exception as e:
            debug('GetLoginURL error:' + str(e))

    def GetUserName(self):
        user = self._uploader.GetUserName()
        self.sendMessage('USER=' + user)
        return user

    def Logout(self):
        self._uploader.Logout()

    def VerifyRedirectURL(self, url):
        return self._uploader.VerifyRedirectURL(url)

    def SetAccessToken(self, token):
        return self._uploader.SetAccessToken(token)

    # def sendMessage(self, msg):
    #     # try:
    #     #     if re.search(r'download_error|sniffer_error|download_complete|sniffer', msg):
    #     #         host = self._website
    #     #
    #     #         if re.search(r'download_error|sniffer_error', msg):
    #     #             jsondata = json.loads(msg)
    #     # except:
    #     #     debug(traceback.format_exc())
    #     super(VideoUploader, self).sendMessage(msg)

    def singleSnifferCallback(self, data):
        self.sendMessage(json.dumps(data))

    def uploadCallback(self, data):
        if 'event' in data and data['event'] == 'download_error' and not self._retry:
            debug('uploadCallback retry begin')
            self._retry = True
            debug('uploadCallback retry end')

            self.sendMessage(json.dumps(data))

    def run(self, data):
        debug('----------------------------------Task Main Run---------------------------------- begin')
        self._cancel = False
        self._retry = False
        try:
            debug('----------------------begin upload-----------------------------------')
            self._uploader.start_upload()
            debug('----------------------end upload-----------------------------------')
        except:
            debug('')
            msg = { 'event': 'download_error', 'error': traceback.format_exc()}
            self.sendMessage(json.dumps(msg))
        finally:
            debug('----------------------------------Task Main Run---------------------------------- end')

    def upload(self, dir, imageSavePath, quality, ext, subtitleLang, speedUp = 'False'):
        debug('-------------------------------------Begin Task--------------------------------')
        data = json.dumps({'quality': quality, 'dir': dir, 'imageSavePath': imageSavePath, 'ext': ext, 'subtitleLang': subtitleLang, 'speedUp': speedUp})
        threading.Thread(target=self.run, args=(data,)).start()

    def StopUpload(self):
        self._uploader.StopUpload()

    def decodeBase64(self, srcText):
        srcText = base64.b64decode(srcText.encode('utf-8'))
        if type(srcText) == bytes:
            srcText = srcText.decode()
        return srcText

    def StartUpload(self, filepath, title='', desc='', privacy='', tags='', category=''):
        debug('start upload...' + filepath)        
        try:
            sfile = self.decodeBase64(filepath)
            title = self.decodeBase64(title)
            desc = self.decodeBase64(desc)
            tags = self.decodeBase64(tags)
            #import base64
            #sfile = base64.b64decode(filepath.encode('utf-8'))
            #if type(sfile) == bytes:
            #    sfile = sfile.decode() 
            debug('start upload...file={},titile={},desc={},tags={},privacy={},category={}'.format(sfile, title, desc, tags, privacy, category))
            self._uploader.StartUpload(sfile, title, desc, privacy, tags, category)
        except Exception as e:            
            debug('StartUpload error: ' + str(e))        

pausedata = None
def callback(str):
    debug(str)
    data = json.loads(str)
    if data.get('event', None) == 'download_cancel':
        global pausedata
        debug(data['data'])
        pausedata = data['data']


if __name__ == "__main__":
    VU = VideoUploader()
    VU.init('Wondershare', 'youtube')
    #VU.SetAccessToken('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')
    url = VU.GetLoginURL()
    print(url)
    webbrowser.open(url)
    url = input('input:')
    VU.VerifyRedirectURL(url)
    print(VU._uploader.GetUserName())
    print(VU.GetAccessToken())
    print(VU._uploader.GetVideoCategories())
    VU.StartUpload(r'RDpcVW5pQ29udmVydGVyXENvbnZlcnRlZFzmsYnlrZcubXA0', title='5YCa5aSp5bGg6b6Z6K6w57Kk6K+tMTggKDIp', desc= 'MTI=', privacy='public', tags='MTI=', category='Film & Animation')

